// Operating System : Windows XP or later, 
// Scilab           : 5.3.3 


//Plot Joint density and distribution function of sum of two Gaussian random variable (Z = X + Y).
clc;
clear all;
clf();

//PDF of Gaussian Random Variable X
mean_x = 0;//mean of first gaussian RV
sd_x = 1;//standard deviation of first gausssian RV
vari_x = sd_x.^2;

x = linspace(-10,10,50);//generating linearly spaced data as Random output
X = ((1/(sqrt(2*%pi*vari_x)))*exp(-0.5.*(x-mean_x).^2/vari_x));//finding gaussian pdf of above data
subplot(2,1,1);
plot(x,X,'r')
xlabel('sample points');
ylabel('PDF of X');
title('PDF of one Random Variable')


//PDF of Gaussian Random Variable Y
mean_y = 0;
sd_y = 1;
vari_y = sd_y.^2;

y = linspace(-10,10,50);
Y = ((1/(sqrt(2*%pi*vari_y)))*exp(-0.5.*(y-mean_y).^2/vari_y));
subplot(2,1,2);
plot(y,Y,'b')
xlabel('sample points');
ylabel('PDF of Y');
title('PDF of second Random Variable')

// Joint pdf of sum of random variable X & Y
// When two IID random variable are summen up, their Joint PDF is convolution between individual pdfs of Random variables
z = convol(X,Y);
figure(2,"BackgroundColor",[1,1,1]);
subplot(2,1,1);plot(linspace(-20,20,99),z)//Joint PDF
xlabel('sample points');
ylabel('PDF of Z');
title('Joint density function of Z = X + Y')
P = cdfnor("PQ",linspace(-20,20,99),mean(z)*ones(z),sqrt(variance(z))*ones(z));
set(gca(),"auto_clear","off")
subplot(2,1,2);plot2d(1:length(P),P,3);
xlabel('sample points');
ylabel('Distribution of Z');
title('Joint distribution function of Z = X + Y')
set(gca(),"auto_clear","on")
//Assignment:
//Change mean and variance of individual random variable X and Y and observe output
